//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.3

import wesual.Controls 1.0

PopupAnchorItem {
    id : infoTip

    property string text

    property int maximumWidth : 330

    readonly property int leftBorder : 23
    readonly property int popupHeight : popupItem ? popupItem.height - 11 : 51

    property var position
    property bool sanitize : false
    property bool mirrored : false

    onPositionChanged : {
        infoTip.x = Math.ceil(infoTip.position.x - leftBorder);
        infoTip.y = Math.ceil(infoTip.position.y - popupHeight);

        infoTip.sanitize = true;
    }

    onDistanceRightChanged : {
        if (!infoTip.sanitize) {
            return;
        }

        sanitizeTopLeftCornerPosition();
    }

    function sanitizeTopLeftCornerPosition() {
        infoTip.popupVisible = false;
        mirrored = false;

        if (infoTip.distanceRight < infoTip.popupItem.width) {
            infoTip.x = Math.ceil(position.x - infoTip.popupItem.width
                                  + leftBorder);
            mirrored = true;
        }

        infoTip.sanitize = false;
        infoTip.popupVisible = true;
    }

    popup : Item {
        id : popupItem

        property string text : infoTip.text
        property Item   textItem

        onTextChanged : {
            var old = textItem;
            textItem = infoTipText.createObject(popupItem, {"text" : text});

            popupItem.width = Math.min(infoTip.maximumWidth,
                                       textItem.implicitWidth + 34);

            if (old)
                old.destroy();
        }

        opacity : 0

        width :  textItem ? textItem.implicitWidth + 34  : 34
        height : textItem ? textItem.implicitHeight + 39 : 39

        BorderImage {
            id : infoTipIcon
            anchors.fill : parent

            border {
                left : mirrored ? 17 : 43
                top : 10
                right : mirrored ? 42 : 18
                bottom : 24
            }

            horizontalTileMode : BorderImage.Stretch
            verticalTileMode : BorderImage.Stretch

            opacity : 1

            source : mirrored ?
                         "qrc:/showcase/icons/infotip-9-slice-right.png" :
                         "qrc:/showcase/icons/infotip-9-slice.png"
        }

        Component {
            id : infoTipText

            Text {
                anchors {
                    left : parent.left
                    leftMargin : 16
                    top : parent.top
                    topMargin : 11
                    right : parent.right
                    rightMargin : 18
                }

                font {
                    family : UI.fontFamily(UI.PrimaryFont)
                    weight : UI.fontWeight(UI.PrimaryFont)
                    pixelSize : 13
                }

                lineHeight : 17
                lineHeightMode : Text.FixedHeight

                maximumLineCount : 12
                wrapMode : Text.WordWrap
                elide : Text.ElideRight

                color : UI.color(UI.PrimaryTextColor)
            }
        }

        states : [
            State {
                name : "visible"
                when : infoTip.popupVisible

                PropertyChanges {
                    target : popupItem
                    opacity : 1
                }
            }
        ]

        transitions : Transition {
            NumberAnimation {
                property : "opacity"
                duration : 150
            }
        }
    }
}

